/****************************************************************************** 
 ** PIC USB Configuration							Create Date	2015/11/08
 **			for PIC18								Last Update	2016/03/12
 ** file name :  usbconfig.h								Saka Softwares
 ** language  :  XC8 (v1.36)
 ******************************************************************************
 ** usbdev.cを使う時、アプリケーション固有の設定を行います。
 ******************************************************************************/
#ifndef _USB_CONFIG_H
#define	_USB_CONFIG_H

/** USB Settings **************************************************************/
// 各エンドポイントのバッファサイズ
#define USB_USE_ENDPOINTS		2		// 使用するエンドポイント数
#define EP0_BUFF_SIZE			8		// EP0 バッファサイズ
#define EP1_OUT_BUFF_SIZE		8		// EP1 Out バッファサイズ
#define EP1_IN_BUFF_SIZE		8		// EP1 In バッファサイズ

// 各ID/リリース番号
#define MY_VID					0x04D8	// ベンダーID	(Microchip)
#define MY_PID					0x0055	// プロダクトID	(HID Keyboard demo)
#define MY_RLS					0x0001	// BCD表現の製品リリース番号

// 電源/構成設定
#define	POW_DEFAULT				0x80	// Default Value (Bit 7 is set)
#define POW_SELF				0x40	// Self-powered (Supports if set)
#define POW_RWU					0x20	// Remote Wakeup (Supports if set)
// 上記を組み合わせて設定値を作る
#define CFG_ATTRIBUTES			POW_DEFAULT
#define	CFG_BUSCURRENT			50		// 最大バス消費電流量 (2mA単位)

/** Hardware Settings for Board ***********************************************/
// SOFのカウンタを使用する設定 (使用しない場合はコメントアウトしてください)
//#define ENSBLE_SOF_COUNTER

// バスパワー検出ピンの設定 (使用する場合下記を書き換えてください)
//#define USE_SELF_POWER_SENSE_IO
#if defined(USE_USB_BUS_SENSE_IO)
	#define tris_usb_bus_sense()	TRISxbits.TRISxx = 1	// 入力設定
	#define usb_bus_sense			PORTxbits.Rxx
#endif

// セルフパワー検出ピンの設定 (使用する場合下記を書き換えてください)
//#define USE_USB_BUS_SENSE_IO
#if defined(USE_SELF_POWER_SENSE_IO)
	#define tris_self_power()		TRISxbits.TRISxx = 1	// 入力設定
	#define self_power				PORTxbits.Rxx
#endif

/******************************************************************************/ 
// USBのステータスででLEDを点滅させるか (main処理)
#define ENABLE_USB_LED_BLINK_STATUS

#endif	//_USB_CONFIG_H
